-- the mysterious middle, huh?

--[[
local function RealtimeSDG(pn)
	-- each bar is 10px wide
	local q = Def.Quad{
		InitCommand=cmd(zoomto,10,0);
		JudgmentMessageCommand=function(self,params)
			if params.Player ~= pn then return end;
			if not params.TapNoteScore then return end;
			
			
		end;
	};
	
	local Values;
	local Bars;
	
	local JudgeNames = {
		"TapNoteScore_W1", "TapNoteScore_W2", "TapNoteScore_W3", "TapNoteScore_W4", "TapNoteScore_Miss",
	};
	local JudgePositions = {
		50, 40, 30, 20, 10, 0,
	};
	
	local PlayerStats = STATSMAN:GetCurStageStats():GetPlayerStageStats(pn);
	
	for i = 1,#JudgeNames do
		Values[i] = PlayerStats:GetTapNoteScores(JudgeNames[i]);
	end;
	
	for i = 1,#JudgeNames do
		Bars[i] = q;
	end;
end;
]]

local function MaxCombo(pn)
	if not pn then return; end;
	return STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):MaxCombo();
end;

local function DancePoints(pn)
	if not pn then return; end;
	return STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):GetActualDancePoints();
end;

local t = Def.ActorFrame{
	-- let's start with the frames:
	LoadActor("_middle section2")..{
		Name="MiddleNoDivider";
		InitCommand=cmd();
	};
	
	LoadActor("_middle section1")..{
		Name="MiddleWithDivider";
		InitCommand=cmd();
		OnCommand=cmd(visible,false);
	};
	
	-- and now for the pages.
	-- page 1: Song Title (wrapwidthpixels,110)
	Def.ActorFrame{
		Name="Page1";
		OnCommand=function(self)
			self:sleep(5);
			MESSAGEMAN:Broadcast("Page2");
			self:sleep(15);
			self:queuecommand("On");
		end;
		
		LoadFont("", "std07_63")..{
			Name="SongTitle";
			Text=GAMESTATE:GetCurrentSong():GetDisplayFullTitle();
			InitCommand=cmd(wrapwidthpixels,110;shadowlength,0);
			OnCommand=cmd(linear,0.2;diffusealpha,1;sleep,5;linear,0.2;diffusealpha,0;sleep,15;queuecommand,"On");
		};
	};
	
	-- page 2: BPM and Max Combos
	Def.ActorFrame{
		Name="Page2";
		OnCommand=function(self)
			self:sleep(10);
			MESSAGEMAN:Broadcast("Page3");
			self:sleep(10);
			self:queuecommand("On");
		end;
		
		-- BPM display
		Def.SongBPMDisplay{
			File=THEME:GetPathF("", "std07_63");
			Name="BPMDisplay";
			InitCommand=cmd(y,20;shadowlength,0);
			OnCommand=cmd(diffusealpha,0;sleep,5;linear,0.2;diffusealpha,1;sleep,5;linear,0.2;diffusealpha,0;sleep,15;queuecommand,"On");
			SetCommand=function(self) self:SetFromGameState(); end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
		};
		
		-- Max Combos
		LoadFont("", "std07_63")..{
			Name="MaxComboP1";
			Text="0";
			InitCommand=cmd(x,-42;shadowlength,0);
			OnCommand=cmd(diffusealpha,0;sleep,5;linear,0.2;diffusealpha,1;sleep,5;linear,0.2;diffusealpha,0;sleep,15;queuecommand,"On");
			CurrentComboChangedP1MessageCommand=function(self)
				self:settext( MaxCombo(PLAYER_1) );
			end;
			Condition=GAMESTATE:IsSideJoined(PLAYER_1);
		};
		
		LoadFont("", "std07_63")..{
			Name="MaxComboP2";
			Text="0";
			InitCommand=cmd(x,42;shadowlength,0);
			OnCommand=cmd(diffusealpha,0;sleep,5;linear,0.2;diffusealpha,1;sleep,5;linear,0.2;diffusealpha,0;sleep,15;queuecommand,"On");
			CurrentComboChangedP2MessageCommand=function(self)
				self:settext( MaxCombo(PLAYER_2) );
			end;
			Condition=GAMESTATE:IsSideJoined(PLAYER_2);
		};
	};
	
	-- page 3: Realtime Step Distribution Graph?
	Def.ActorFrame{
		Name="Page3";
		OnCommand=function(self)
			self:sleep(15);
			MESSAGEMAN:Broadcast("Page4");
			self:sleep(5);
			self:queuecommand("On");
		end;
		
		LoadFont("", "std07_63")..{
			Text="LOL NOT CODED YET";
			InitCommand=cmd(wrapwidthpixels,110;shadowlength,0);
			OnCommand=cmd(diffusealpha,0;sleep,10;linear,0.2;diffusealpha,1;sleep,5;linear,0.2;diffusealpha,0;sleep,5;queuecommand,"On");
		};
	};
	
	-- page 4: Dance Points Comparison
	Def.ActorFrame{
		Name="Page4";
		OnCommand=function(self)
			self:sleep(20);
			MESSAGEMAN:Broadcast("Page1");
			self:queuecommand("On");
		end;
		
		-- Max Combos
		LoadFont("", "std07_63")..{
			Name="DancePointsP1";
			Text="0";
			InitCommand=cmd(x,-42;shadowlength,0);
			OnCommand=cmd(diffusealpha,0;sleep,15;linear,0.2;diffusealpha,1;sleep,5;linear,0.2;diffusealpha,0;sleep,15;queuecommand,"On");
			JudgmentMessageCommand=function(self)
				self:settext( DancePoints(PLAYER_1) );
			end;
			Condition=GAMESTATE:IsSideJoined(PLAYER_1);
		};
		
		LoadFont("", "std07_63")..{
			Name="DancePointsP2";
			Text="0";
			InitCommand=cmd(x,42;shadowlength,0);
			OnCommand=cmd(diffusealpha,0;sleep,15;linear,0.2;diffusealpha,1;sleep,5;linear,0.2;diffusealpha,0;sleep,15;queuecommand,"On");
			JudgmentMessageCommand=function(self)
				self:settext( DancePoints(PLAYER_2) );
			end;
			Condition=GAMESTATE:IsSideJoined(PLAYER_2);
		};
	};
};

return t;

-- coded by Synikal over a Winter